<?php

namespace App\Http\Controllers;

use App\Models\Requisito;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
class RequisitoController extends Controller
{
    public function index()
    {
        $requisitos = Requisito::all();
        return view('requisitos.index', compact('requisitos'));
    }

    public function create()
    {
        return view('requisitos.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:100',
            'descripcion' => 'nullable|string',
        ]);

        $requisito = Requisito::create([
            'nombre' => $request->nombre,
            'descripcion' => $request->descripcion,
            'activo' => 1
        ]);

        return response()->json([
            'message' => 'Requisito creado correctamente.',
            'requisito' => $requisito
        ]);
    }


    public function edit($id)
    {
        $requisito = Requisito::findOrFail($id);
        return view('requisitos.edit', compact('requisito'));
    }

    public function update(Request $request, $id)
    {
        // Validación de los campos
        $request->validate([
            'nombre' => 'required|max:100',
            'descripcion' => 'nullable|string',
            'activo' => 'required|in:0,1', // Validar que el valor de 'activo' sea 0 o 1
        ]);

        // Recoger los valores enviados, en este caso 'activo' es 0 o 1 desde el select
        $activo = $request->input('activo');  // Ya recibimos 0 o 1 directamente

        // Encontrar el requisito y actualizarlo
        $requisito = Requisito::findOrFail($id);
        $requisito->update([
            'nombre' => $request->nombre,
            'descripcion' => $request->descripcion,
            'activo' => $activo, // Guardar el valor de 'activo' directamente como 0 o 1
        ]);

        // Si la solicitud es AJAX, devolver la respuesta como JSON
        if ($request->ajax()) {
            return response()->json(['success' => true, 'message' => 'Requisito actualizado correctamente.']);
        }

        // Si no es AJAX, redirigir con un mensaje de éxito
        return redirect()->route('requisitos.index')->with('success', 'Requisito actualizado correctamente.');
    }



    public function destroy($id)
    {
        $requisito = Requisito::findOrFail($id);
        $requisito->delete();

        // Si la solicitud es AJAX, devolver la respuesta como JSON
        if (request()->ajax()) {
            return response()->json(['success' => true, 'message' => 'Requisito eliminado correctamente.']);
        }

        return redirect()->route('requisitos.index')->with('success', 'Requisito eliminado correctamente.');
    }

}
