<?php

namespace App\Http\Controllers;

use App\Models\LogroCurso;
use App\Models\SubcomponenteLogro;
use Illuminate\Http\Request;

class SubcomponenteLogroController extends Controller
{
    public function index($logro_id)
    {
        $logro = LogroCurso::findOrFail($logro_id);
        $curso = $logro->curso; // Relación con el modelo Curso
        $subcomponentes = SubcomponenteLogro::where('logro_curso_id', $logro_id)->get();

        return view('docentes.subcomponentes.index', compact('logro', 'curso', 'subcomponentes'));
    }


    public function store(Request $request, $logro_id)
    {
        $request->validate([
            'nombre' => 'required|string|max:100',
            'descripcion' => 'nullable|string',
            'peso' => 'required|numeric|min:0|max:100',
        ]);

        // Obtener la suma actual de pesos de los subcomponentes del logro
        $pesoActual = SubcomponenteLogro::where('logro_curso_id', $logro_id)->sum('peso');

        // Verificar que la suma total no supere 100
        if (($pesoActual + $request->peso) > 100) {
            return response()->json([
                'success' => false,
                'message' => 'La suma de los pesos supera el 100%. Actualmente hay ' . $pesoActual . '%.'
            ], 422);
        }

        SubcomponenteLogro::create([
            'logro_curso_id' => $logro_id,
            'nombre' => $request->nombre,
            'descripcion' => $request->descripcion,
            'peso' => $request->peso,
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Subcomponente registrado correctamente.'
        ]);
    }


}
