<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Registro de Postulación</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background: linear-gradient(rgba(0, 32, 96, 0.6), rgba(0, 32, 96, 0.6)),
                        url('https://images.unsplash.com/photo-1523050854058-8df90110c9f1?auto=format&fit=crop&w=1500&q=80');
            background-size: cover;
            background-position: center;
            min-height: 100vh;
            padding-top: 40px;
            padding-bottom: 40px;
            font-family: "Segoe UI", sans-serif;
        }

        .instituto-header {
            text-align: center;
            color: white;
            margin-bottom: 25px;
        }

        .instituto-header img {
            height: 110px;
            margin-bottom: 10px;
            filter: drop-shadow(0px 0px 6px rgba(0, 0, 0, .4));
        }

        .card-form {
            border-radius: 15px;
            background: #ffffffcc;
            backdrop-filter: blur(6px);
            padding: 30px;
        }

        h5 {
            border-left: 4px solid #003b7a;
            padding-left: 10px;
            font-weight: bold;
            color: #003b7a;
        }

        label {
            font-weight: 600;
            color: #333;
        }

        .btn-custom {
            background: #003b7a;
            color: white;
            font-size: 17px;
            padding: 12px;
            border-radius: 8px;
            transition: 0.3s;
            font-weight: bold;
        }

        .btn-custom:hover {
            background: #0056b3;
            transform: translateY(-2px);
        }
    </style>
</head>


<body>

    <!-- ENCABEZADO DEL INSTITUTO -->
    <div class="container instituto-header">
        <?php if($instituto && $instituto->logo): ?>
            <img src="<?php echo e(asset('storage/' . $instituto->logo)); ?>" alt="Logo Instituto">
        <?php endif; ?>

        <h2><?php echo e($instituto->nombre); ?></h2>
        <p>
            <?php echo e($instituto->direccion); ?> <br>
            Teléfono: <?php echo e($instituto->telefono); ?>

        </p>
    </div>

    <div class="container" style="max-width: 900px;">

        <div class="card shadow-lg card-form">

            <h3 class="text-center text-primary mb-4">Formulario de Postulación</h3>

            <?php if(session('success')): ?>
                <div class="alert alert-success"><?php echo e(session('success')); ?></div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <strong>Corrige los siguientes errores:</strong>
                    <ul class="mt-2 mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($e); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>


            <form action="<?php echo e(route('postulacion.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <!-- DATOS PERSONALES -->
                <h5 class="mt-3">Datos Personales</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label>Nombres *</label>
                        <input type="text" name="nombres" class="form-control" required>
                    </div>

                    <div class="col-md-6">
                        <label>Apellidos *</label>
                        <input type="text" name="apellidos" class="form-control" required>
                    </div>

                    <div class="col-md-4">
                        <label>DNI *</label>
                        <input type="text" name="dni" class="form-control" maxlength="15" required>
                    </div>

                    <div class="col-md-4">
                        <label>Email *</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>

                    <div class="col-md-4">
                        <label>Teléfono</label>
                        <input type="text" name="telefono" class="form-control">
                    </div>

                    <div class="col-md-4">
                        <label>Género *</label>
                        <select name="genero" class="form-control" required>
                            <option value="">Seleccione</option>
                            <option>Masculino</option>
                            <option>Femenino</option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label>Fecha de nacimiento *</label>
                        <input type="date" name="fecha_nacimiento" class="form-control" required>
                    </div>

                    <div class="col-md-4">
                        <label>Dirección</label>
                        <input type="text" name="direccion" class="form-control">
                    </div>
                </div>

                <!-- DATOS DE POSTULACIÓN -->
                <h5 class="mt-4">Datos de Postulación</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label>Proceso de Admisión *</label>
                        <select name="id_admision" class="form-control" required>
                            <option value="">Seleccione</option>
                            <?php $__currentLoopData = $admisiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $adm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($adm->id_admision); ?>"><?php echo e($adm->nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label>Plan de Estudios *</label>
                        <select name="id_plan" class="form-control" required>
                            <option value="">Seleccione</option>
                            <?php $__currentLoopData = $planes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($p->id); ?>"><?php echo e($p->nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label>Segunda opción (opcional)</label>
                        <input type="text" name="segunda_opcion" class="form-control">
                    </div>
                </div>

                <!-- DOCUMENTOS -->
                <h5 class="mt-4">Documentos Obligatorios</h5>

                <div class="row g-3">

                    <div class="col-md-6">
                        <label>Foto del postulante *</label>
                        <input type="file" name="foto_postulante" class="form-control" required>
                    </div>

                    <div class="col-md-6">
                        <label>Certificado de Estudios *</label>
                        <input type="file" name="certificado_estudios" class="form-control" required>
                    </div>

                    <div class="col-md-6">
                        <label>Partida de nacimiento *</label>
                        <input type="file" name="partida_nacimiento" class="form-control" required>
                    </div>

                    <div class="col-md-6">
                        <label>Copia de DNI *</label>
                        <input type="file" name="copia_dni" class="form-control" required>
                    </div>

                    <div class="col-md-6">
                        <label>Comprobante de pago *</label>
                        <input type="file" name="comprobante_pago" class="form-control" required>
                    </div>

                </div>

                <button class="btn btn-custom mt-4 w-100">
                    Registrar Postulación
                </button>

            </form>

        </div>
    </div>

</body>
</html>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/postulacion/form.blade.php ENDPATH**/ ?>