<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MatriculaCurso extends Model
{
    use HasFactory;

    protected $table = 'matricula_cursos';

    protected $fillable = [
        'matricula_id',
        'curso_id',
        'estado',
        'fecha_matricula',
    ];

    public function matricula()
    {
        return $this->belongsTo(Matricula::class, 'matricula_id');
    }

    public function curso()
    {
        return $this->belongsTo(Curso::class, 'curso_id');
    }
    // En el modelo MatriculaCurso
    public function asistencias()
    {
        return $this->hasMany(Asistencia::class, 'matricula_curso_id', 'id');
    }

    public function estudiante()
    {
        return $this->hasOneThrough(
            Postulante::class,     // Modelo final
            Matricula::class,      // Modelo intermedio
            'id',                  // Foreign key en Matricula hacia MatriculaCurso (matricula_id)
            'id_postulante',       // Foreign key en Postulante hacia Matricula (postulante_id)
            'matricula_id',        // Local key en MatriculaCurso
            'postulante_id'        // Local key en Matricula
        );
    }

    public function notaFinal()
{
    return $this->hasOne(NotaFinal::class, 'curso_id', 'curso_id')
                ->whereColumn('estudiante_id', 'matricula.postulante_id');
}

    
}
