<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ModuloFormativo extends Model
{
    use HasFactory;

    // Nombre de la tabla en la base de datos
    protected $table = 'modulos_formativos';

    // Definir la clave primaria de la tabla
    protected $primaryKey = 'id_modulo';

    // Definir los campos que se pueden asignar masivamente
    protected $fillable = [
        'id_plan_estudio',
        'nombre',
        'num_modulo',
        'horas',
        'creditos',
    ];

    // Relación con la tabla planes_estudio
    public function planEstudio()
    {
        return $this->belongsTo(PlanEstudio::class, 'id_plan_estudio');
    }

    // Relación con la tabla cursos (un módulo puede tener varios cursos)
    public function cursos()
    {
        return $this->hasMany(Curso::class, 'id_modulo');
    }
}
