<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PlanesEstudioPeriodo extends Model
{
    use HasFactory;

    protected $table = 'planes_estudio_periodos';

    protected $fillable = [
        'plan_estudio_id',
        'periodo_id',
    ];

    public function planEstudio()
    {
        return $this->belongsTo(PlanEstudio::class, 'plan_estudio_id');
    }

    public function periodo()
    {
        return $this->belongsTo(Periodo::class, 'periodo_id');
    }
}
