<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Unidades Didacticas <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                

                <div class="table-responsive">
                
                <form id="formCurso" action="<?php echo e(route('cursos.update', $curso->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="card mb-4 shadow-sm">
                        <div class="card-header bg-primary text-white fw-semibold">
                            <i class="fas fa-edit me-2"></i>Editar Curso
                        </div>
                        <div class="card-body">
                            <div class="row">
                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="nombre" class="form-label">Nombre del Curso</label>
                                        <input type="text" name="nombre" class="form-control" value="<?php echo e(old('nombre', $curso->nombre)); ?>" required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="tipo" class="form-label">Tipo</label>
                                        <select name="tipo" class="form-select" required>
                                            <option value="">Seleccione</option>
                                            <option value="Especialidad" <?php echo e($curso->tipo == 'Especialidad' ? 'selected' : ''); ?>>Especialidad</option>
                                            <option value="Transversal" <?php echo e($curso->tipo == 'Transversal' ? 'selected' : ''); ?>>Transversal</option>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="descripcion" class="form-label">Descripción</label>
                                        <textarea name="descripcion" class="form-control" rows="4"><?php echo e(old('descripcion', $curso->descripcion)); ?></textarea>
                                    </div>
                                </div>

                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="creditos" class="form-label">Créditos</label>
                                        <input type="text" name="creditos" class="form-control" value="<?php echo e(old('creditos', $curso->creditos)); ?>">
                                    </div>

                                    <div class="mb-3">
                                        <label for="horas_semestrales" class="form-label">Horas Semestrales</label>
                                        <input type="number" name="horas_semestrales" class="form-control" value="<?php echo e(old('horas_semestrales', $curso->horas_semestrales)); ?>">
                                    </div>

                                    <div class="mb-3">
                                        <label for="planes_estudio" class="form-label">Planes de Estudio</label>
                                        <select name="planes_estudio[]" id="planes_estudio" class="form-select" required>
                                            <option value="">Seleccione</option>
                                            <?php $__currentLoopData = $planesEstudio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($plan->id); ?>" <?php echo e(in_array($plan->id, $curso->planesEstudio->pluck('id')->toArray()) ? 'selected' : ''); ?>>
                                                    <?php echo e($plan->nombre); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>

                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="id_modulo" class="form-label">Módulo Formativo</label>
                                        <select name="id_modulo" id="id_modulo" class="form-select" required>
                                            <option value="">Seleccione un módulo</option>
                                            <?php $__currentLoopData = $modulos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modulo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($modulo->id_modulo); ?>" <?php echo e($modulo->id_modulo == $curso->id_modulo ? 'selected' : ''); ?>>
                                                    <?php echo e($modulo->nombre); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="semestre_id" class="form-label">Semestre</label>
                                        <select name="semestre_id" class="form-select" required>
                                            <option value="">Seleccione</option>
                                            <?php $__currentLoopData = $semestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semestre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($semestre->id); ?>" <?php echo e($semestre->id == $curso->semestre_id ? 'selected' : ''); ?>>
                                                    <?php echo e($semestre->nombre); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="orden" class="form-label">Orden</label>
                                        <input type="number" name="orden" class="form-control" value="<?php echo e(old('orden', $curso->orden)); ?>">
                                    </div>
                                </div>
                            </div>

                            
                            <div class="d-flex justify-content-end gap-2">
                                <a href="<?php echo e(route('cursos.index')); ?>" class="btn btn-outline-danger">
                                    <i class="fas fa-times"></i> Cancelar
                                </a>
                                <button type="submit" class="btn btn-success">
                                    <i class="fas fa-save me-1"></i> Actualizar Curso
                                </button>
                            </div>
                        </div>
                    </div>
                </form>




                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>







<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>




<script>
    // Cuando se cambie el plan de estudio
    document.getElementById('planes_estudio').addEventListener('change', function () {
        const planId = this.value;

        if (!planId) return;

        fetch(`/modulos-por-plan/${planId}`)
            .then(response => response.json())
            .then(data => {
                const moduloSelect = document.getElementById('id_modulo');
                moduloSelect.innerHTML = '<option value="">Seleccione</option>';

                data.forEach(modulo => {
                    const option = document.createElement('option');
                    option.value = modulo.id_modulo;
                    option.text = modulo.nombre;
                    moduloSelect.appendChild(option);
                });
            })
            .catch(error => {
                console.error('Error al cargar módulos:', error);
            });
    });

    
</script>

<script>
    $(document).on('submit', '#formCurso', function(e) {
        e.preventDefault();

        let formData = new FormData(this);
        formData.append('_method', 'PUT');  // Añadir método PUT

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST', // Siempre POST, pero simulando el método PUT
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        title: '¡Éxito!',
                        text: response.message,
                        icon: 'success',
                        confirmButtonText: 'Cerrar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Redirige al índice de cursos después de la confirmación
                            window.location.href = "<?php echo e(route('cursos.index')); ?>"; // Redirigir a la lista de cursos
                        }
                    });
                } else {
                    Swal.fire({
                        title: 'Error',
                        text: response.message,
                        icon: 'error',
                        confirmButtonText: 'Cerrar'
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.fire({
                    title: 'Error',
                    text: 'Ocurrió un error al actualizar el curso. Por favor, intente nuevamente.',
                    icon: 'error',
                    confirmButtonText: 'Cerrar'
                });
            }
        });
    });




    
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/cursos/edit.blade.php ENDPATH**/ ?>