<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Modulo extends Model
{
    use HasFactory;

    protected $table = 'modulos';

    protected $fillable = [
        'nombre',
        'descripcion',
    ];

    /**
     * Relación con los roles que tienen acceso a este módulo.
     */
    public function roles()
    {
        return $this->belongsToMany(Role::class, 'modulo_roles', 'modulo_id', 'rol_id');
    }
}
