<?php

namespace App\Http\Controllers;

use App\Models\Anuncio;
use App\Models\PlanEstudio;
use Illuminate\Http\Request;

class AnuncioController extends Controller
{
    public function index()
{
    $anuncios = Anuncio::with('planEstudio')->get();
    $planes = PlanEstudio::all();
    return view('anuncios.index', compact('anuncios', 'planes'));
}


    public function create()
    {
        $planes = PlanEstudio::all();
        return view('anuncios.create', compact('planes'));
    }

    public function store(Request $request)
{
    $request->validate([
        'titulo' => 'required|string|max:255',
        'contenido' => 'required|string',
        'plan_estudio_id' => 'required|exists:planes_estudio,id',
        'activo' => 'nullable|boolean',
    ]);

    $anuncio = Anuncio::create($request->all());

    return response()->json([
        'success' => true,
        'message' => 'Anuncio creado correctamente.',
        'anuncio' => $anuncio
    ]);
}
public function show($id)
{
    $anuncio = Anuncio::findOrFail($id);
    return response()->json($anuncio);
}


    public function edit($id)
    {
        $anuncio = Anuncio::findOrFail($id);
        $planes = PlanEstudio::all();
        return view('anuncios.edit', compact('anuncio', 'planes'));
    }

    public function update(Request $request, $id)
{
    $request->validate([
        'titulo' => 'required|string|max:255',
        'contenido' => 'required|string',
        'plan_estudio_id' => 'required|exists:planes_estudio,id',
        'activo' => 'nullable|boolean',
    ]);

    $anuncio = Anuncio::findOrFail($id);
    $anuncio->update($request->all());

    return response()->json(['message' => 'Anuncio actualizado correctamente.']);
}


    public function destroy($id)
{
    $anuncio = Anuncio::findOrFail($id);
    $anuncio->delete();

    return response()->json(['message' => 'Anuncio eliminado.']);
}

}
