<?php

namespace App\Http\Controllers;

use App\Models\Modulo;
use Illuminate\Http\Request;

class ModuloController extends Controller
{
    /**
     * Mostrar todos los módulos.
     */
    public function index()
    {
        $modulos = Modulo::all();
        return view('moduloss.index', compact('modulos'));
    }

    /**
     * Almacenar un nuevo módulo.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:100|unique:modulos,nombre',
            'descripcion' => 'nullable|string|max:255',
        ]);

        Modulo::create($request->only('nombre', 'descripcion'));

        return redirect()->back()->with('success', 'Módulo creado correctamente.');
    }

    /**
     * Mostrar los detalles de un módulo.
     */
    public function show($id)
    {
        $modulo = Modulo::findOrFail($id);
        return response()->json($modulo);
    }

    /**
     * Actualizar un módulo.
     */
    public function update(Request $request, $id)
    {
        $modulo = Modulo::findOrFail($id);

        $request->validate([
            'nombre' => 'required|string|max:100|unique:modulos,nombre,' . $id,
            'descripcion' => 'nullable|string|max:255',
        ]);

        $modulo->update($request->only('nombre', 'descripcion'));

        return redirect()->back()->with('success', 'Módulo actualizado correctamente.');
    }

    /**
     * Eliminar un módulo.
     */
    public function destroy($id)
    {
        $modulo = Modulo::findOrFail($id);
        $modulo->delete();

        return redirect()->back()->with('success', 'Módulo eliminado correctamente.');
    }
}
