<?php

namespace App\Http\Controllers;

use App\Models\Postulacion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PostulacionController extends Controller
{
    /**
     * Registrar una nueva postulación.
     */
    public function store(Request $request)
    {
        $request->validate([
            'id_oferta' => 'required|exists:ofertas_laborales,id_oferta',
        ]);

        $usuario = Auth::user();
        $postulante = $usuario->estudiante;

        if (!$postulante) {
            return response()->json(['error' => 'No se encontró el perfil del postulante.'], 404);
        }

        // Verificar si ya está postulado
        $yaPostulado = Postulacion::where('id_postulante', $postulante->id_postulante)
                                  ->where('id_oferta', $request->id_oferta)
                                  ->exists();

        if ($yaPostulado) {
            return response()->json(['warning' => 'Ya te has postulado a esta oferta.'], 409);
        }

        // Registrar la postulación
        Postulacion::create([
            'id_postulante' => $postulante->id_postulante,
            'id_oferta' => $request->id_oferta,
        ]);

        return response()->json(['success' => 'Postulación registrada correctamente.']);
    }

    public function misPostulaciones()
    {
        $usuario = Auth::user();
        $postulante = $usuario->estudiante;

        if (!$postulante) {
            return redirect()->route('dashboard')->with('error', 'No se encontró el perfil del postulante.');
        }

        $postulaciones = Postulacion::with('oferta')
            ->where('id_postulante', $postulante->id_postulante)
            ->latest()
            ->get();

        return view('estudiantes.postulaciones.index', compact('postulaciones'));
    }

    public function destroy($id)
    {
        $usuario = Auth::user();
        $postulante = $usuario->estudiante;

        $postulacion = Postulacion::where('id_postulacion', $id)
            ->where('id_postulante', $postulante->id_postulante)
            ->with('oferta')
            ->firstOrFail();

        if (\Carbon\Carbon::parse($postulacion->oferta->fecha_fin)->isPast()) {
            return response()->json(['error' => 'No puedes cancelar una postulación vencida.'], 403);
        }

        $postulacion->delete();

        return response()->json(['success' => 'Postulación cancelada correctamente.']);
    }


}

