<?php

namespace App\Http\Controllers;

use App\Models\Seccion;
use Illuminate\Http\Request;

class SeccionController extends Controller
{
    public function index()
    {
        $secciones = Seccion::all();
        return view('secciones.index', compact('secciones'));
    }

    public function create()
    {
        return view('secciones.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'descripcion' => 'nullable|string',
        ]);

        Seccion::create([
            'nombre' => $request->nombre,
            'descripcion' => $request->descripcion,
        ]);

        return response()->json(['message' => 'Sección registrada con éxito.']);
    }


    public function show(Seccion $seccion)
    {
        return view('secciones.show', compact('seccion'));
    }

    public function edit(Seccion $seccion)
    {
        return view('secciones.edit', compact('seccion'));
    }

    public function update(Request $request, $id)
    {
        $seccion = Seccion::findOrFail($id);
        $seccion->update($request->only('nombre', 'descripcion'));

        return response()->json([
            'success' => true,
            'message' => 'Sección actualizada correctamente.',
        ]);
    }


    public function destroy($id)
    {
        try {
            $seccion = Seccion::findOrFail($id);
            $seccion->delete();

            return response()->json([
                'success' => true,
                'message' => 'Sección eliminada correctamente.'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Error al eliminar la sección.'
            ]);
        }
    }

}
