<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Semestre;
class SemestreController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $semestres = Semestre::all();
        return view('semestres.index', compact('semestres'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:50|unique:semestres,nombre',
            'descripcion' => 'nullable|string',
            'activo' => 'required|boolean',
        ]);

        $semestre = Semestre::create([
            'nombre' => $request->nombre,
            'descripcion' => $request->descripcion,
            'activo' => $request->activo,
            'fecha_creacion' => now(),
        ]);

        return response()->json([
            'message' => 'Semestre registrado correctamente',
            'semestre' => $semestre,
        ]);
    }


    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'nombre' => 'required|string|max:50|unique:semestres,nombre,' . $id,
            'descripcion' => 'nullable|string',
            'activo' => 'required|boolean',
        ]);

        $semestre = Semestre::findOrFail($id);
        $semestre->update([
            'nombre' => $request->nombre,
            'descripcion' => $request->descripcion,
            'activo' => $request->activo,
        ]);

        return response()->json([
            'message' => 'Semestre actualizado correctamente',
            'semestre' => $semestre,
        ]);
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $semestre = Semestre::findOrFail($id);
        $semestre->delete();

        return response()->json(['message' => 'Semestre eliminado correctamente']);
    }

}
