<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Curso;
use App\Models\Silabo;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class SilaboController extends Controller
{
    public function index($curso_id)
    {
        $docente_id = Auth::user()->docente->id ?? null;

        $curso = Curso::findOrFail($curso_id);

        $asignado = $curso->docentes()->where('docente_id', $docente_id)->exists();
        if (!$asignado) {
            abort(403, 'No tienes permiso para acceder a este curso.');
        }

        $silabo = Silabo::where('curso_id', $curso_id)->first();

        return view('docentes.silabos.index', compact('curso', 'silabo'));
    }

    public function store(Request $request, $curso_id)
{
    $request->validate([
        'archivo' => 'required|mimes:pdf|max:10240' // Solo PDFs, máximo 10MB
    ]);

    // Obtener archivo
    $archivo = $request->file('archivo');

    // Generar nombre único
    $nombreArchivo = time() . '_' . $archivo->getClientOriginalName();

    // Definir ruta de destino en public/storage/silabos
    $directorio = public_path('storage/silabos');

    // Crear directorio si no existe
    if (!file_exists($directorio)) {
        mkdir($directorio, 0755, true);
    }

    // Mover archivo al destino
    $archivo->move($directorio, $nombreArchivo);

    // Ruta relativa para guardar en la base de datos
    $rutaArchivo = 'silabos/' . $nombreArchivo;

    // Crear o actualizar el sílabo
    $silabo = Silabo::updateOrCreate(
        ['curso_id' => $curso_id],
        [
            'archivo' => $rutaArchivo,
            'fecha_subida' => now()
        ]
    );

    // Responder en formato JSON para AJAX
    return response()->json([
        'message' => 'Sílabo subido correctamente.',
        'silabo' => $silabo
    ]);
}


public function destroy($id)
{
    $silabo = Silabo::findOrFail($id);

    // Ruta completa al archivo
    $rutaArchivo = public_path('storage/' . $silabo->archivo);

    // Eliminar archivo físico si existe
    if (file_exists($rutaArchivo)) {
        unlink($rutaArchivo);
    }

    // Eliminar registro en base de datos
    $silabo->delete();

    return response()->json(['message' => 'Sílabo eliminado correctamente.']);
}



}
