<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Tramite;
use App\Models\SolicitudTramite;
use Illuminate\Support\Facades\Auth;

class SolicitudTramiteController extends Controller
{
    // Listar trámites activos para que el estudiante pueda elegir
    public function listarTramites()
    {
        $tramites = Tramite::where('estado', 'Activo')->get();
        return view('estudiantes.tramites.listar', compact('tramites'));
    }

    // Mostrar formulario para solicitar un trámite
    public function createSolicitud($tramiteId)
    {
        $tramite = Tramite::with('requisitos')->findOrFail($tramiteId);

        return view('estudiantes.tramites.partials.modal_solicitud', compact('tramite'));
    }


    // Guardar solicitud de trámite
   public function storeSolicitud(Request $request)
{
    $request->validate([
        'tramite_id' => 'required|exists:tramites,id',
        
        'archivo' => 'nullable|file|max:2048',
    ]);

    $postulanteId = Auth::user()->estudiante->id_postulante;

    // Verificar si ya existe una solicitud pendiente o en proceso
    $existePendiente = SolicitudTramite::where('postulante_id', $postulanteId)
        ->where('tramite_id', $request->tramite_id)
        ->whereIn('estado', ['pendiente', 'en_proceso'])
        ->exists();

    if ($existePendiente) {
        return response()->json([
            'error' => 'Ya tienes una solicitud en proceso para este trámite.'
        ], 422);
    }

    $archivoPath = null;
    if ($request->hasFile('archivo')) {
        $archivo = $request->file('archivo');
        $nombreArchivo = time() . '_' . $archivo->getClientOriginalName();
        $destino = public_path('tramitesestudiantes');

        if (!file_exists($destino)) {
            mkdir($destino, 0775, true);
        }

        $archivo->move($destino, $nombreArchivo);
        $archivoPath = 'tramitesestudiantes/' . $nombreArchivo;
    }

    SolicitudTramite::create([
        'postulante_id' => $postulanteId,
        'tramite_id' => $request->tramite_id,
        'estado' => 'pendiente',
        'prioridad' => 'media',
        'area_id' => '2',
        'archivo' => $archivoPath,
        'fecha_solicitud' => now(),
    ]);

    return response()->json([
        'success' => 'Solicitud enviada correctamente.'
    ]);
}


    // Listar solicitudes realizadas por el estudiante
    public function indexSolicitudes()
    {
        $postulanteId = Auth::user()->estudiante->id_postulante;
        $solicitudes = SolicitudTramite::with('tramite')
            ->where('postulante_id', $postulanteId)
            ->orderBy('fecha_solicitud', 'desc')
            ->get();

        return view('estudiantes.solicitudes.index', compact('solicitudes'));
    }
}
