<?php

namespace App\Http\Controllers;

use App\Models\TipoContrato;
use Illuminate\Http\Request;

class TipoContratoController extends Controller
{
    public function index()
    {
        $tipos = TipoContrato::all();
        return view('tipos_contrato.index', compact('tipos'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre_tipo_contrato' => 'required|string|max:50',
            'estado' => 'required|in:Activo,Inactivo',
        ]);

        TipoContrato::create($request->only('nombre_tipo_contrato', 'estado'));

        return response()->json(['message' => 'Tipo de contrato creado con éxito.']);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nombre_tipo_contrato' => 'required|string|max:50',
            'estado' => 'required|in:Activo,Inactivo',
        ]);

        $tipo = TipoContrato::findOrFail($id);
        $tipo->update($request->only('nombre_tipo_contrato', 'estado'));

        return response()->json(['message' => 'Tipo de contrato actualizado con éxito.']);
    }

    public function destroy($id)
    {
        $tipo = TipoContrato::findOrFail($id);
        $tipo->delete();

        return response()->json(['message' => 'Tipo de contrato eliminado con éxito.']);
    }
}
