<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Inscripcion extends Model
{
    protected $table = 'inscripcion';
    protected $primaryKey = 'id_inscripcion';
    public $timestamps = false; // La tabla no tiene created_at ni updated_at

    protected $fillable = [
        'id_admision',
        'id_postulante',
        'id_plan',
        'segunda_opcion',
        'fecha_registro',
        'estado',
        'observacion',
    ];

    // Relaciones
    public function admision()
    {
        return $this->belongsTo(Admision::class, 'id_admision', 'id_admision');
    }

    public function postulante()
    {
        return $this->belongsTo(Postulante::class, 'id_postulante', 'id_postulante');
    }

    public function plan()
    {
        return $this->belongsTo(PlanEstudio::class, 'id_plan', 'id');
    }
}
