<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LogroCurso extends Model
{
    use HasFactory;

    protected $table = 'logros_curso';

    protected $fillable = [
        'curso_id',
        'nombre',
        'descripcion',
        'fecha_creacion',
    ];

    public $timestamps = false; // Ya usas `fecha_creacion`, así que no necesitas `created_at` ni `updated_at`

    // Relación con el curso
    public function curso()
    {
        return $this->belongsTo(Curso::class, 'curso_id');
    }

    // Relación con subcomponentes
    public function subcomponentes()
    {
        return $this->hasMany(SubcomponenteLogro::class, 'logro_curso_id');
    }

    public function notasLogro()
{
    return $this->hasMany(NotaLogro::class, 'logro_curso_id');
}
}
