<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Postulacion extends Model
{
    use HasFactory;

    protected $table = 'postulaciones';
    protected $primaryKey = 'id_postulacion';
    public $timestamps = true;

    protected $fillable = [
        'id_postulante',
        'id_oferta',
        'fecha_postulacion',
    ];

    public function postulante()
    {
        return $this->belongsTo(Postulante::class, 'id_postulante', 'id_postulante');
    }

    public function oferta()
    {
        return $this->belongsTo(OfertaLaboral::class, 'id_oferta', 'id_oferta');
    }

    

}
