<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SubcomponenteLogro extends Model
{
    use HasFactory;

    protected $table = 'subcomponentes_logro';

    protected $fillable = [
        'logro_curso_id',
        'nombre',
        'descripcion',
        'peso',
    ];

    public $timestamps = false; // ya que la tabla usa `fecha_creacion`, no `created_at`

    protected $casts = [
        'peso' => 'float',
        'fecha_creacion' => 'datetime',
    ];

    // Relación con LogroCurso
    public function logroCurso()
    {
        return $this->belongsTo(LogroCurso::class, 'logro_curso_id');
    }
    public function notas()
{
    return $this->hasMany(NotaSubcomponente::class, 'subcomponente_id');
}

}
