@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Administrador @endslot
@slot('title') Areas @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                 <div class="card shadow rounded-3">
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="rolSelect" class="form-label">Selecciona un Rol</label>
                            <select id="rolSelect" class="form-select">
                                <option value="" disabled selected>-- Seleccione un rol --</option>
                                @foreach($roles as $rol)
                                    <option value="{{ $rol->id }}">{{ $rol->nombre }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div id="modulosContainer" class="d-none">
                            <h5 class="mt-4 mb-3">Módulos disponibles</h5>
                            <form id="moduloForm">
                                <input type="hidden" name="rol_id" id="rol_id">
                                <div class="row">
                                    @foreach($modulos as $modulo)
                                        <div class="col-md-6">
                                            <div class="form-check form-switch mb-2">
                                                <input class="form-check-input modulo-switch" type="checkbox" name="modulo_ids[]" value="{{ $modulo->id }}" id="modulo_{{ $modulo->id }}">
                                                <label class="form-check-label" for="modulo_{{ $modulo->id }}">{{ $modulo->nombre }}</label>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                <button type="submit" class="btn btn-primary mt-3">Guardar Asignación</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>






<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const rolSelect = document.getElementById('rolSelect');
        const modulosContainer = document.getElementById('modulosContainer');
        const rolIdInput = document.getElementById('rol_id');
        const moduloForm = document.getElementById('moduloForm');

        rolSelect.addEventListener('change', function () {
            const rolId = this.value;
            rolIdInput.value = rolId;

            // Limpiar switches
            document.querySelectorAll('.modulo-switch').forEach(s => s.checked = false);

            fetch(`/admin/modulo-roles/${rolId}`)
                .then(response => response.json())
                .then(data => {
                    // Marcar switches asignados
                    data.forEach(id => {
                        const checkbox = document.getElementById('modulo_' + id);
                        if (checkbox) checkbox.checked = true;
                    });
                    modulosContainer.classList.remove('d-none');
                });
        });

        moduloForm.addEventListener('submit', function (e) {
            e.preventDefault();

            const formData = new FormData(moduloForm);

            fetch("{{ route('modulo-roles.asignar') }}", {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: formData
            })
            .then(resp => resp.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('¡Éxito!', data.message, 'success');
                } else {
                    Swal.fire('Error', 'Ocurrió un problema.', 'error');
                }
            })
            .catch(() => {
                Swal.fire('Error', 'No se pudo completar la solicitud.', 'error');
            });
        });
    });
</script>


@endsection
