@extends('layouts.master')
@section('title') Ofertas Laborales @endsection

@section('content')
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Estudiante @endslot
@slot('title') Ofertas Laborales @endslot
@endcomponent

<!-- Filtro -->
<div class="row mb-4">
    <div class="col-md-4">
        <input type="text" id="filtro_nombre" class="form-control" placeholder="Buscar por título...">
    </div>
    <div class="col-md-4">
        <input type="text" id="filtro_lugar" class="form-control" placeholder="Buscar por lugar...">
    </div>
    <div class="col-md-4">
        <select id="filtro_plan" class="form-select">
            <option value="">-- Filtrar por Plan de Estudio --</option>
            @foreach($planesEstudio as $plan)
                <option value="{{ $plan->id }}">{{ $plan->nombre }}</option>
            @endforeach
        </select>
    </div>
</div>
<!-- Contenedor para modales cargados dinámicamente -->
<div id="modales_dinamicos"></div>


<!-- Resultados -->
<div class="row g-4" id="contenedor_ofertas">
    @include('estudiantes.ofertas.partials.lista_ofertas', ['ofertas' => $ofertas])
</div>
@endsection

@section('script')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).on('click', '.btn-postular', function () {
        let idOferta = $(this).data('id');

        Swal.fire({
            title: '¿Deseas postularte a esta oferta?',
            text: 'Esta acción no se puede deshacer.',
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Sí, postularme',
            cancelButtonText: 'Cancelar',
            confirmButtonColor: '#28a745'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('postulaciones.store') }}",
                    type: 'POST',
                    data: {
                        _token: "{{ csrf_token() }}",
                        id_oferta: idOferta
                    },
                    success: function (response) {
                        Swal.fire({
                            icon: 'success',
                            title: '¡Postulación exitosa!',
                            text: response.success,
                            confirmButtonColor: '#28a745'
                        });
                        $('#modalOferta' + idOferta).modal('hide');
                    },
                    error: function (xhr) {
                        let msg = 'Ocurrió un error.';
                        if (xhr.status === 409 && xhr.responseJSON.warning) {
                            msg = xhr.responseJSON.warning;
                        } else if (xhr.responseJSON && xhr.responseJSON.error) {
                            msg = xhr.responseJSON.error;
                        }

                        Swal.fire({
                            icon: 'warning',
                            title: 'Aviso',
                            text: msg
                        });
                    }
                });
            }
        });
    });
</script>

<script>
    function cargarOfertas() {
        let nombre = $('#filtro_nombre').val();
        let lugar = $('#filtro_lugar').val();
        let plan = $('#filtro_plan').val();

        $.ajax({
            url: "{{ route('estudiantes.ofertas.ajax') }}",
            method: 'GET',
            data: { nombre, lugar, plan },
            success: function(response) {
                $('#contenedor_ofertas').html(response);
            },
            error: function() {
                alert('Error al cargar ofertas.');
            }
        });
    }

    $(document).ready(function() {
        $('#filtro_nombre, #filtro_lugar, #filtro_plan').on('input change', function() {
            cargarOfertas();
        });
    });

    


</script>

<script>
function mostrarModal(id) {
    $.ajax({
        url: "{{ route('estudiantes.ofertas.modal') }}", // crea esta ruta para retornar solo el modal
        method: 'GET',
        data: { id_oferta: id },
        success: function(html) {
            $('#modales_dinamicos').html(html);
            let modal = new bootstrap.Modal(document.getElementById('modalOferta' + id));
            modal.show();
        },
        error: function() {
            alert('No se pudo cargar el detalle.');
        }
    });
}
</script>
@endsection
