@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Academico @endslot
@slot('title') Plan de Estudio - Periodo @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <div class="table-responsive">
                    <table id="tablaPlanesEstudio" class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>Plan de Estudio</th>
                                <th>Periodos Asociados</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($planes as $plan)
                                <tr>
                                    <td class="fw-bold">{{ $plan->nombre }}</td>
                                    <td>
                                        @if($plan->periodos->isEmpty())
                                            <span class="text-muted">Ninguno</span>
                                        @else
                                            <div class="d-flex flex-wrap gap-2">
                                                @foreach($plan->periodos as $periodo)
                                                    <span class="badge bg-primary">{{ $periodo->nombre }}</span>
                                                @endforeach
                                            </div>
                                        @endif
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-primary btn-asociar-periodo"
                                            data-plan-id="{{ $plan->id }}" data-plan-nombre="{{ $plan->nombre }}">
                                            Asociar Periodo
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>




                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>


<!-- Modal para Asociar Periodos -->
<div class="modal fade" id="modalAsociarPeriodo" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="formAsociarPeriodos" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-header">
                    <h5 class="modal-title" id="tituloModal">Asociar Periodos</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <div class="row" id="contenedorPeriodos"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                </div>
            </form>
        </div>
    </div>
</div>






<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<script>
    $(document).ready(function () {
        $("#tablaPlanesEstudio").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPlanesEstudio_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
    $(document).ready(function () {
    // Al hacer clic en el botón para asociar periodos
    $('.btn-asociar-periodo').on('click', function () {
        const planId = $(this).data('plan-id');
        const planNombre = $(this).data('plan-nombre');

        $('#tituloModal').text('Asociar Periodos a: ' + planNombre);
        $('#formAsociarPeriodos').attr('action', '/planes-estudio/' + planId + '/asociar-periodos');

        $.ajax({
            url: '/planes-estudio/' + planId + '/obtener-periodos',
            type: 'GET',
            success: function (data) {
                if (!data || !data.periodos) {
                    alert('No se han recibido periodos correctamente.');
                    return;
                }

                let periodosHTML = '';
                data.periodos.forEach(function (periodo) {
                    periodosHTML += `
                        <div class="col-12 col-md-4 mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="${periodo.id}" 
                                    id="periodo_${periodo.id}" name="periodos[]" ${periodo.checked ? 'checked' : ''}>
                                <label class="form-check-label" for="periodo_${periodo.id}">
                                    ${periodo.nombre}
                                </label>
                            </div>
                        </div>`;
                });

                $('#contenedorPeriodos').html(periodosHTML);

                // Mostrar modal después de cargar los datos
                const modal = new bootstrap.Modal(document.getElementById('modalAsociarPeriodo'));
                modal.show();
            },
            error: function () {
                alert('Error al cargar los periodos.');
            }
        });
    });

    // Cuando el formulario se envíe, mostrar una alerta SweetAlert
    $('#formAsociarPeriodos').on('submit', function (e) {
        e.preventDefault();  // Prevenir que el formulario se envíe de forma tradicional

        const formAction = $(this).attr('action');
        const formData = $(this).serialize();

        $.ajax({
            url: formAction,
            type: 'POST',
            data: formData,
            success: function (response) {
                // Mostrar SweetAlert
                Swal.fire({
                    icon: 'success',
                    title: '¡Éxito!',
                    text: 'La asociación de periodos se actualizó correctamente.',
                    confirmButtonText: 'Cerrar'
                }).then(() => {
                    // Cerrar el modal después de la alerta
                    const modal = bootstrap.Modal.getInstance(document.getElementById('modalAsociarPeriodo'));
                    modal.hide();

                    // Opcional: Aquí puedes recargar la página o actualizar los datos de la tabla
                    location.reload();
                });
            },
            error: function () {
                // Mostrar SweetAlert en caso de error
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Hubo un problema al actualizar la asociación de periodos.',
                    confirmButtonText: 'Cerrar'
                });
            }
        });
    });
});

</script>







@endsection
