<style>
    .btn-purple {
        border-color: #6f42c1;
        color: #6f42c1;
    }
    .btn-purple:hover {
        background-color: #6f42c1;
        color: #fff;
    }
</style>

@if(count($cursosConNotas) > 0)
    <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
        @foreach($cursosConNotas as $curso)
            <div class="col">
                <div class="card h-100 border-0 shadow-sm rounded-4" style="background-color: #f8f9fa;">
                    <div class="card-body d-flex flex-column">
                        <!-- Título del curso -->
                        <h5 class="card-title mb-3 text-primary fw-semibold">
                            <i class="bi bi-book-fill me-2"></i> {{ $curso['nombre'] }}
                        </h5>

                        <!-- Información adicional -->
                        <ul class="list-unstyled small mb-3">
                            <li>
                                <i class="bi bi-person-fill text-muted me-1"></i>
                                <strong>Docente:</strong> {{ $curso['docente'] ?? 'No asignado' }}
                            </li>
                            <li>
                                <i class="bi bi-clock text-muted me-1"></i>
                                <strong>Horario:</strong> {{ $curso['horario'] ?? 'Sin horario' }}
                            </li>
                            <li>
                                <i class="bi bi-door-open text-muted me-1"></i>
                                <strong>Aula:</strong> {{ $curso['aula'] ?? 'No asignada' }}
                            </li>
                        </ul>

                        <!-- Estado y nota -->
                        <ul class="list-unstyled small mb-4">
                            <li>
                                <i class="bi bi-check-circle me-1 text-muted"></i>
                                <strong>Estado:</strong> {{ $curso['estado'] }}
                            </li>
                            <li>
                                <i class="bi bi-bar-chart me-1 text-muted"></i>
                                <strong>Nota Final:</strong>
                                @if($curso['nota'] === '-' || $curso['nota'] === null || !is_numeric($curso['nota']))
                                    <span class="text-muted">-</span>
                                @else
                                    <span class="{{ $curso['nota'] >= 11 ? 'text-success' : 'text-danger' }}">
                                        {{ number_format($curso['nota'], 2) }}
                                    </span>
                                @endif
                            </li>
                        </ul>

                        <!-- Botones -->
                        <div class="mt-auto d-grid gap-2">
                            <a href="{{ route('estudiante.cursos.ver', $curso['id']) }}" class="btn btn-outline-primary btn-sm">
                                <i class="bi bi-journal-text me-1"></i> Ver Curso
                            </a>


                            <a href="#" class="btn btn-outline-success btn-sm" onclick="verAsistencia({{ $curso['id'] }})">
                                <i class="bi bi-calendar-check me-1"></i> Asistencia
                            </a>

                            <a href="#" class="btn btn-outline-purple btn-sm" onclick="verNotas({{ $curso['id'] }})" data-bs-toggle="modal" data-bs-target="#modalNotas">
                                <i class="bi bi-graph-up me-1"></i> Ver Notas
                            </a>

                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@else
    <div class="alert alert-info">
        No tienes cursos matriculados actualmente.
    </div>
@endif

<div class="modal fade" id="modalNotas" tabindex="-1" aria-labelledby="modalNotasLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detalle de Notas</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body" id="contenidoNotas">
                <div class="text-center text-muted">Cargando...</div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Asistencia -->
<div class="modal fade" id="modalAsistencia" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">Detalle de Asistencia</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="contenidoAsistencia">
                <!-- Se carga por AJAX -->
            </div>
        </div>
    </div>
</div>

@if(isset($anunciosActivos) && count($anunciosActivos))
<div class="modal fade" id="modalAnuncios" tabindex="-1" aria-labelledby="modalAnunciosLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content border-0 shadow-lg rounded-4">
            <div class="modal-header bg-gradient bg-blue text-white rounded-top-4">
                <h5 class="modal-title fw-bold" id="modalAnunciosLabel">
                    <i class="bi bi-megaphone-fill me-2"></i> Comunicados Importantes
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>

            <div class="modal-body p-0">
                <div id="carouselAnuncios" class="carousel slide" data-bs-ride="carousel">
                    <div class="carousel-inner">
                        @foreach($anunciosActivos as $index => $anuncio)
                            <div class="carousel-item {{ $index === 0 ? 'active' : '' }}">
                                <div class="p-4">
                                    <h5 class="text-primary fw-semibold mb-2">
                                        <i class="bi bi-info-circle-fill me-2"></i>{{ $anuncio->titulo }}
                                    </h5>
                                    <hr class="my-2">
                                    <div class="text-dark">{!! $anuncio->contenido !!}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>

                    @if(count($anunciosActivos) > 1)
                        <button class="carousel-control-prev" type="button" data-bs-target="#carouselAnuncios" data-bs-slide="prev">
                            <span class="carousel-control-prev-icon bg-dark rounded-circle p-2"></span>
                        </button>
                        <button class="carousel-control-next" type="button" data-bs-target="#carouselAnuncios" data-bs-slide="next">
                            <span class="carousel-control-next-icon bg-dark rounded-circle p-2"></span>
                        </button>
                    @endif
                </div>
            </div>

            <div class="modal-footer bg-light rounded-bottom-4">
                <button type="button" class="btn btn-primary" data-bs-dismiss="modal">
                    <i class="bi bi-x-circle me-1"></i> Cerrar
                </button>
            </div>
        </div>
    </div>
</div>
@endif

<script>
    function verNotas(cursoId) {
    const url = `/estudiante/cursos/${cursoId}/notas`;

    fetch(url)
        .then(response => response.text())
        .then(html => {
            document.getElementById('contenidoNotas').innerHTML = html;
        })
        .catch(error => {
            console.error('Error al cargar las notas:', error);
            document.getElementById('contenidoNotas').innerHTML = `<div class="alert alert-danger">No se pudieron cargar las notas.</div>`;
        });
}


function verAsistencia(cursoId) {
    fetch(`/estudiante/asistencia/${cursoId}`)
        .then(res => res.json())
        .then(data => {
            document.getElementById('contenidoAsistencia').innerHTML = data.html;
            new bootstrap.Modal(document.getElementById('modalAsistencia')).show();
        });
}

</script>

@if(isset($anunciosActivos) && count($anunciosActivos))
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const modal = new bootstrap.Modal(document.getElementById('modalAnuncios'));
        modal.show();
    });
</script>


@endif
