@if(count($cursosAgrupados))
    <div class="accordion" id="accordionSemestres">
        @foreach($cursosAgrupados as $semestre => $turnos)
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading-{{ Str::slug($semestre) }}">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-{{ Str::slug($semestre) }}" aria-expanded="false" aria-controls="collapse-{{ Str::slug($semestre) }}">
                        <i class="fas fa-calendar-alt me-2"></i> Semestre - {{ $semestre }}
                    </button>
                </h2>
                <div id="collapse-{{ Str::slug($semestre) }}" class="accordion-collapse collapse" aria-labelledby="heading-{{ Str::slug($semestre) }}" data-bs-parent="#accordionSemestres">
                    <div class="accordion-body">
                        @foreach($turnos as $turno => $secciones)
                            <h5 class="text-info mt-3"><i class="fas fa-clock me-2"></i>Turno: {{ $turno }}</h5>
                            @foreach($secciones as $seccion => $horarios)
                                <h6 class="text-muted mb-3"><i class="fas fa-users me-2"></i>Sección: {{ $seccion }}</h6>
                                <div class="row">
                                    @foreach($horarios as $horario)
                                        <div class="col-md-6 col-lg-4 mb-4">
                                            <div class="card shadow-sm border-0 rounded-4 h-100">
                                                <div class="card-body d-flex flex-column">
                                                    <h5 class="card-title">{{ $horario->curso->nombre }}</h5>
                                                    <ul class="list-unstyled small mb-3">
                                                        <li><strong>Módulo:</strong> {{ $horario->curso->modulo->nombre ?? 'N/A' }}</li>
                                                        <li><strong>Créditos:</strong> {{ $horario->curso->creditos ?? 'N/A' }}</li>
                                                        <li><strong>Horas:</strong> {{ $horario->curso->horas_semestrales ?? 'N/A' }}</li>
                                                        <li><strong>Día:</strong> {{ $horario->dia }}</li>
                                                        <li><strong>Hora:</strong> {{ $horario->hora_inicio }} - {{ $horario->hora_fin }}</li>
                                                    </ul>
                                                    <div class="mt-auto d-flex justify-content-between flex-wrap gap-1">
                                                        <a href="{{ route('docente.cursos.informacion', $horario->curso->id) }}" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-book-open me-1"></i> Ver Curso
                                                        </a>
                                                        <a href="{{ route('docente.logros.index', $horario->curso->id) }}" class="btn btn-sm btn-outline-success">
                                                            <i class="fas fa-trophy me-1"></i> Logros
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endforeach
                        @endforeach
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@else
    <div class="alert alert-info">No tienes cursos asignados para los filtros seleccionados.</div>
@endif
