<?php if(count($cursosAgrupados)): ?>
    <div class="accordion" id="accordionSemestres">
        <?php $__currentLoopData = $cursosAgrupados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semestre => $turnos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="accordion-item">
                <h2 class="accordion-header" id="heading-<?php echo e(Str::slug($semestre)); ?>">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo e(Str::slug($semestre)); ?>" aria-expanded="false" aria-controls="collapse-<?php echo e(Str::slug($semestre)); ?>">
                        <i class="fas fa-calendar-alt me-2"></i> Semestre - <?php echo e($semestre); ?>

                    </button>
                </h2>
                <div id="collapse-<?php echo e(Str::slug($semestre)); ?>" class="accordion-collapse collapse" aria-labelledby="heading-<?php echo e(Str::slug($semestre)); ?>" data-bs-parent="#accordionSemestres">
                    <div class="accordion-body">
                        <?php $__currentLoopData = $turnos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turno => $secciones): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <h5 class="text-info mt-3"><i class="fas fa-clock me-2"></i>Turno: <?php echo e($turno); ?></h5>
                            <?php $__currentLoopData = $secciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seccion => $horarios): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <h6 class="text-muted mb-3"><i class="fas fa-users me-2"></i>Sección: <?php echo e($seccion); ?></h6>
                                <div class="row">
                                    <?php $__currentLoopData = $horarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $horario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6 col-lg-4 mb-4">
                                            <div class="card shadow-sm border-0 rounded-4 h-100">
                                                <div class="card-body d-flex flex-column">
                                                    <h5 class="card-title"><?php echo e($horario->curso->nombre); ?></h5>
                                                    <ul class="list-unstyled small mb-3">
                                                        <li><strong>Módulo:</strong> <?php echo e($horario->curso->modulo->nombre ?? 'N/A'); ?></li>
                                                        <li><strong>Créditos:</strong> <?php echo e($horario->curso->creditos ?? 'N/A'); ?></li>
                                                        <li><strong>Horas:</strong> <?php echo e($horario->curso->horas_semestrales ?? 'N/A'); ?></li>
                                                        <li><strong>Día:</strong> <?php echo e($horario->dia); ?></li>
                                                        <li><strong>Hora:</strong> <?php echo e($horario->hora_inicio); ?> - <?php echo e($horario->hora_fin); ?></li>
                                                    </ul>
                                                    <div class="mt-auto d-flex justify-content-between flex-wrap gap-1">
                                                        <a href="<?php echo e(route('docente.cursos.informacion', $horario->curso->id)); ?>" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-book-open me-1"></i> Ver Curso
                                                        </a>
                                                        <a href="<?php echo e(route('docente.logros.index', $horario->curso->id)); ?>" class="btn btn-sm btn-outline-success">
                                                            <i class="fas fa-trophy me-1"></i> Logros
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php else: ?>
    <div class="alert alert-info">No tienes cursos asignados para los filtros seleccionados.</div>
<?php endif; ?>
<?php /**PATH D:\SISTEMAS\academico-master\resources\views/roles/partials/cursos_docente.blade.php ENDPATH**/ ?>