<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Listado de Convalidaciones <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <button class="btn btn-outline-primary mb-3" data-bs-toggle="modal" data-bs-target="#modalReporte">
                    Generar reporte por fecha
                </button>
                <div class="table-responsive">
                    <table id="tablaPeriodos" class="table table-striped mb-0 table-hover">
                        <thead >
                            <tr>
                                <th>#</th>
                                <th>Estudiante</th>
                                <th>Curso Destino</th>
                                <th>Curso Origen</th>
                                <th>Institución Origen</th>
                                <th>Nota</th>
                                <th>Periodo</th>
                                <th>Fecha</th>
                                <th>Observaciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $convalidaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($item->estudiante->nombres ?? 'N/A'); ?> <?php echo e($item->estudiante->apellidos ?? 'N/A'); ?></td>
                                    <td><?php echo e($item->cursoDestino->nombre ?? 'N/A'); ?></td>
                                    <td><?php echo e($item->curso_origen); ?></td>
                                    <td><?php echo e($item->institucion_origen); ?></td>
                                    <td><?php echo e($item->nota_origen); ?></td>
                                    <td><?php echo e($item->periodo->nombre ?? 'N/A'); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($item->fecha_convalidacion)->format('d/m/Y')); ?></td>
                                    <td><?php echo e($item->observaciones); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center">No hay convalidaciones registradas.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>


<!--end row-->
<!-- Modal -->
<div class="modal fade" id="modalReporte" tabindex="-1" aria-labelledby="modalReporteLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="<?php echo e(route('convalidaciones.reporte')); ?>" target="_blank" id="formReporteConvalidaciones">
        <?php echo csrf_field(); ?>
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title" id="modalReporteLabel">Reporte de Convalidaciones por Fecha</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
            <div class="mb-3">
                <label for="fecha_inicio" class="form-label">Fecha de inicio</label>
                <input type="date" name="fecha_inicio" class="form-control" required>
            </div>
            <div class="mb-3">
                <label for="fecha_fin" class="form-label">Fecha de fin</label>
                <input type="date" name="fecha_fin" class="form-control" required>
            </div>
            </div>
            <div class="modal-footer">
            <button type="submit" class="btn btn-success">Generar PDF</button>
            </div>
        </div>
    </form>
  </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPeriodos").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPeriodos_wrapper .col-md-6:eq(0)');
    });
</script>

<script>
document.getElementById('formReporteConvalidaciones').addEventListener('submit', function(e) {
    e.preventDefault();

    const form = this;
    const fechaInicio = form.querySelector('[name="fecha_inicio"]').value;
    const fechaFin = form.querySelector('[name="fecha_fin"]').value;

    if (!fechaInicio || !fechaFin) {
        alert('Ambas fechas son obligatorias.');
        return;
    }

    // Crear un formulario en memoria y enviarlo
    const formData = new FormData(form);
    const url = form.action;

    const newWindow = window.open('', '_blank');

    fetch(url, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': form.querySelector('input[name="_token"]').value
        }
    })
    .then(res => res.blob())
    .then(blob => {
        const blobUrl = URL.createObjectURL(blob);
        newWindow.location.href = blobUrl;
    })
    .catch(() => {
        newWindow.close();
        alert('Error generando el PDF.');
    });

    // Cierra el modal
    bootstrap.Modal.getInstance(document.getElementById('modalReporte')).hide();
});
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/convalidaciones/listado.blade.php ENDPATH**/ ?>