<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Academico <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Ver Horarios <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                <a href="<?php echo e(route('horarios.create')); ?>" class="btn btn-de-primary btn-sm px-4 mt-0 mb-3">
                    <i class="fas fa-plus"></i> Agregar Horario
                </a>


        
                <div class="table-responsive">
                
                <table id="tablahorarios" class="table table-striped mb-0 table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>Curso</th>
                            <th>Docente</th>
                            <th>Periodo</th>
                            <th>Plan de Estudio</th>
                            <th>Hora Inicio</th>
                            <th>Hora Fin</th>
                            <th>Día</th>
                            <th>Tipo Aula</th>
                            <th>N° Aula</th>
                            <th>Frecuencia</th>
                            <th>Capacidad</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $horarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $horario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr id="horario-<?php echo e($horario->id); ?>"> <!-- Aquí agregas el ID único -->
                                <td><?php echo e($horario->curso->nombre ?? '-'); ?></td>
                                <td><?php echo e($horario->docente?->nombre . ' ' . $horario->docente?->apellido ?? '-'); ?></td>
                                <td><?php echo e($horario->periodo->nombre ?? '-'); ?></td>
                                <td><?php echo e($horario->planEstudio->nombre ?? '-'); ?></td>
                                <td><?php echo e($horario->hora_inicio); ?></td>
                                <td><?php echo e($horario->hora_fin); ?></td>
                                <td><?php echo e($horario->dia); ?></td>
                                <td><?php echo e($horario->tipo_aula); ?></td>
                                <td><?php echo e($horario->numero_aula); ?></td>
                                <td><?php echo e($horario->frecuencia); ?></td>
                                <td><?php echo e($horario->capacidad); ?></td>
                                <td>
                                    <!-- Editar -->
                                    <a href="javascript:void(0);" class="text-warning" onclick="openEditModal(<?php echo e($horario->id); ?>)">
                                        <i class="las la-pen text-secondary font-18"></i>
                                    </a>


                                    <!-- Eliminar -->
                                    <form action="<?php echo e(route('horarios.destroy', $horario->id)); ?>" method="POST" class="d-inline delete-form" id="delete-form-<?php echo e($horario->id); ?>">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="button" class="btn btn-link p-0" onclick="deleteHorario(<?php echo e($horario->id); ?>)">
                                            <i class="las la-trash-alt text-secondary font-18"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>




                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal para editar horario -->
<!-- Modal para editar horario -->
<div class="modal fade" id="editHorarioModal" tabindex="-1" aria-labelledby="editHorarioModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg"> <!-- más ancho -->
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editHorarioModalLabel">Editar Horario</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <div class="modal-body">
                <form id="editHorarioForm">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <input type="hidden" name="id" id="horarioId">

                    <div class="row g-3">

                        <!-- Hora Inicio y Fin -->
                        <div class="col-md-6">
                            <div class="card shadow-sm p-3">
                                <h6 class="mb-3">Horario</h6>
                                <div class="mb-3">
                                    <label for="hora_inicio" class="form-label">Hora de Inicio</label>
                                    <input type="time" name="hora_inicio" id="hora_inicio" class="form-control">
                                </div>
                                <div>
                                    <label for="hora_fin" class="form-label">Hora de Fin</label>
                                    <input type="time" name="hora_fin" id="hora_fin" class="form-control">
                                </div>
                            </div>
                        </div>

                        <!-- Día y Frecuencia -->
                        <div class="col-md-6">
                            <div class="card shadow-sm p-3">
                                <h6 class="mb-3">Frecuencia y Día</h6>
                                <div class="mb-3">
                                    <label for="dia" class="form-label">Día de la semana</label>
                                    <select name="dia" id="dia" class="form-select">
                                        <option value="Lunes">Lunes</option>
                                        <option value="Martes">Martes</option>
                                        <option value="Miércoles">Miércoles</option>
                                        <option value="Jueves">Jueves</option>
                                        <option value="Viernes">Viernes</option>
                                        <option value="Sábado">Sábado</option>
                                        <option value="Domingo">Domingo</option>
                                    </select>
                                </div>
                                <div>
                                    <label for="frecuencia" class="form-label">Frecuencia</label>
                                    <select name="frecuencia" id="frecuencia" class="form-select">
                                        <option value="Semanal">Semanal</option>
                                        <option value="Quincenal">Quincenal</option>
                                        <option value="Mensual">Mensual</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Tipo Aula y Número -->
                        <div class="col-md-6">
                            <div class="card shadow-sm p-3">
                                <h6 class="mb-3">Aula</h6>
                                <div class="mb-3">
                                    <label for="tipo_aula" class="form-label">Tipo de Aula</label>
                                    <select name="tipo_aula" id="tipo_aula" class="form-select">
                                        <option value="Aula">Aula</option>
                                        <option value="Laboratorio">Laboratorio</option>
                                    </select>
                                </div>
                                <div>
                                    <label for="numero_aula" class="form-label">Número de Aula</label>
                                    <input type="text" name="numero_aula" id="numero_aula" class="form-control">
                                </div>
                            </div>
                        </div>

                        

                        <!-- Capacidad -->
                        <div class="col-md-6">
                            <div class="card shadow-sm p-3">
                                <h6 class="mb-3">Capacidad</h6>
                                <div>
                                    <label for="capacidad" class="form-label">Capacidad</label>
                                    <input type="number" name="capacidad" id="capacidad" class="form-control">
                                </div>
                            </div>
                        </div>

                    </div>

                    <!-- Footer del formulario -->
                    <div class="modal-footer mt-4">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                        <button type="submit" class="btn btn-primary">Guardar cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>





<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablahorarios").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablahorarios_wrapper .col-md-6:eq(0)');
    });
</script>


<script>
    function deleteHorario(horarioId) {
        // Usamos SweetAlert para pedir confirmación
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡Este horario será eliminado permanentemente!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // Si el usuario confirma, enviamos la solicitud AJAX
                let form = document.getElementById('delete-form-' + horarioId);
                let formData = new FormData(form);

                fetch(form.action, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire(
                            'Eliminado!',
                            'El horario ha sido eliminado.',
                            'success'
                        ).then(() => {
                            // Aquí podemos actualizar la vista, por ejemplo, eliminando el horario de la tabla
                            document.getElementById('horario-' + horarioId).remove();
                        });
                    } else {
                        Swal.fire(
                            'Error!',
                            'Hubo un problema al eliminar el horario.',
                            'error'
                        );
                    }
                })
                .catch(error => {
                    Swal.fire(
                        'Error!',
                        'Hubo un problema al eliminar el horario.',
                        'error'
                    );
                });
            }
        });
    }

    // Función para abrir el modal y cargar los datos actuales del horario
    function openEditModal(horarioId) {
        // Hacer una petición AJAX para obtener los detalles del horario
        $.ajax({
            url: '/horarios/' + horarioId + '/edit',
            type: 'GET',
            success: function(response) {
                // Poner los datos del horario en el modal
                $('#horarioId').val(response.id);
                $('#hora_inicio').val(response.hora_inicio);
                $('#hora_fin').val(response.hora_fin);
                $('#dia').val(response.dia);
                $('#tipo_aula').val(response.tipo_aula);
                $('#numero_aula').val(response.numero_aula);
                $('#frecuencia').val(response.frecuencia);
                $('#capacidad').val(response.capacidad);

                // Mostrar el modal
                $('#editHorarioModal').modal('show');
            },
            error: function() {
                alert('No se pudo obtener los detalles del horario');
            }
        });
    }

    // Enviar los datos modificados mediante AJAX
    $('#editHorarioForm').submit(function(e) {
        e.preventDefault();

        var formData = $(this).serialize();

        $.ajax({
            url: '/horarios/' + $('#horarioId').val(),
            type: 'PUT',
            data: formData,
            success: function(response) {
                // Cerrar el modal
                $('#editHorarioModal').modal('hide');

                // Actualizar la tabla con los nuevos datos del horario
                // Aquí debes actualizar la fila correspondiente, puedes usar un identificador único
                var row = $('#horario-' + response.id);
                row.find('.hora_inicio').text(response.hora_inicio);
                row.find('.hora_fin').text(response.hora_fin);
                row.find('.dia').text(response.dia);
                row.find('.tipo_aula').text(response.tipo_aula);
                row.find('.numero_aula').text(response.numero_aula);
                row.find('.frecuencia').text(response.frecuencia);
                row.find('.capacidad').text(response.capacidad);

                // Mostrar un mensaje de éxito con SweetAlert
                Swal.fire('¡Éxito!', 'Horario actualizado correctamente', 'success');
            },
            error: function() {
                Swal.fire('Error', 'Hubo un problema al actualizar el horario', 'error');
            }
        });
    });

</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\SISTEMAS\academico-master\resources\views/horarios/index.blade.php ENDPATH**/ ?>